import numpy as np


def get_stat(data):
    data_mean, data_std = {}, {}
    for k in data:
        data_mean[k] = np.mean(data[k], axis=0)
        data_std[k] = np.std(data[k], axis=0)

    data_mean_mean, data_mean_std = {}, {}
    for k in data:
        tmp_array = np.mean(data[k], axis=1)
        data_mean_mean[k] = np.mean(tmp_array)
        data_mean_std[k] = np.std(tmp_array)

    for k in data_mean:
        print(k, data_mean[k], data_std[k], data_mean_mean[k], data_mean_std[k])

adp = {'hc_mixed': [[0.64749, 0.10827], [0.67153, 0.11593], [0.71185, 0.12050]],
       'hc_med': [[1.3849, 0.05552], [1.3394, 0.0561], [1.4376, 0.05870]],
       'hc_rnd': [[0.31799, 0.01445], [0.33100, 0.01510], [0.36748, 0.01717]], 
       'hc_m_exp': [[1.4105, 0.068103], [1.36547, 0.07138], [1.4954, 0.073729]],
       'hp_m_exp': [[7.2793, 184.42], [1.6034, 17.481], [2.1127, 12.484]],
       'hp_m_rep': [[0.14994, 0.86317], [0.20030, 1.7713], [0.15917, 0.89730]], 
       'hp_med': [[0.46463, 30.924], [0.38425, 11.022], [0.43863, 15.134]],
       'hp_rnd': [[0.20967, 0.012413], [0.23964, 0.012515], [0.24589, 0.010649]],
       'wk_m_exp': [[60.886, 139.60], [52.414, 111.08], [53.779, 114.87]],
       'wk_m_rep': [[72.375, 31.242], [56.384, 23.313], [71.725, 27.083]],
       'wk_med': [[33.354, 28.176], [34.713, 18.350], [33.963, 26.608]],
       'wk_rnd': [[77.462, 1.6538], [56.627, 1.2994], [52.221, 1.1395]]}

ufm = {'hc_mixed': [[0.66534, 0.10654], [0.70236, 0.11513], [0.75250, 0.12017]],
       'hc_med': [[1.3463, 0.05911], [1.3140, 0.06067], [1.4054, 0.06194]],
       'hc_rnd': [[0.32381, 0.01522], [0.33693, 0.01611], [0.36547, 0.017850]], 
       'hc_m_exp': [[1.4574, 0.071767], [1.41672, 0.072767], [1.52789, 0.076838]],
       'hp_m_exp': [[21.124, 424.29], [16.185, 395.73], [17.497, 334.13]],
       'hp_m_rep': [[0.17035, 4.9267], [0.28773, 2.6314], [0.17747, 2.4023]], 
       'hp_med': [[0.52149, 59.990], [0.59449, 60.427], [0.59535, 84.294]],
       'hp_rnd': [[0.18354, 0.012145], [0.18400, 0.022639], [0.20069, 0.031727]],
       'wk_m_exp': [[52.279, 191.71], [51.216, 183.43], [52.19, 183.63]],
       'wk_m_rep': [[46.04, 63.296], [42.82, 56.08], [44.98, 62.177]],
       'wk_med': [[34.37, 117.99], [34.347, 111.18], [34.058, 110.17]],
       'wk_rnd': [[137.84, 5.9055], [105.2, 4.4792], [92.90, 4.3379]]}

get_stat(adp)
print("###################################################################################")
get_stat(ufm)

